@extends('layouts.adminlayout')
@section('title','CARRISOFT V2: BON DE COMMANDE')

@section('extra-meta')
    <meta name="csrf-token" content="{{ csrf_token() }}">
@endsection

@section('content')
    <main class="col-sm-12 ml-sm-auto col-md-12 pt-0" style="text-decoration: none; margin-top: 5px;margin-bottom: 20px">
        <h3 class="ml-5"><b>{{__('messages.GESTION DES COMMANDES')}}</b></h3>
        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-md-6 float-left">
                <h3 class="ml-5">{{__('messages.Generer une commande')}}</h3>
            </div>
            
            <div class="col-12 col-sm-6 col-md-4 float-right">
             <a href="{{route('cmde.histo')}}" class="btn btn-danger"><i class="fa fa-info"></i>{{__('messages.Historique des Cmdes')}}</a>
            </div>
        </div>
        <br></br></br>
        
        <div class="col-12 col-sm-12 col-md-12">
            <div class="col-12 col-md-5 float-left contour">
                
                <form method="POST" action="{{route('cmde.generer')}}">
                    @csrf
                    <div class="form-group">
                        <label>{{__('messages.Selectionner un inventaire')}}</label>
                        <select name="inventaire_id" id="inventaire_id" class="form-control">
                            @foreach($inventaires as $key=>$inventaire)
                                <option value= "{!! $inventaire !!}"> {!! $inventaire !!} </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>{{__('messages.Date debut CMM')}}</label>
                        <input type="date" name="date_debut" id="date_debut" class="form-control" />
                    </div>    
                    <div class="form-group">
                        <label>{{__('messages.Date fin CMM')}}</label>
                        <input type="date" name="date_fin" id="datefint" class="form-control" />
                    </div>
                    <div class="form-group">
                    <button class="btn btn-primary bleu_claire"><i class="fa fa-save"></i> {{__('messages.Generer')}}</button>
                    </div>
                      
                </form>
            </div>
        </div>
        <br><br>
        
    </main>
@endsection

@section('extra-js')
    <script>
        function inventaire() {
            $.ajax({
                url:"cmde.inventaires",
                dataType:"json",
                success:function(data)
                {
                    $('#inventaire_id').empty();
                    $('#inventaire_id').append('<option id=0  value=0>- {{__('messages.Selectionner un inventaire')}} -</option>');
                    for (var i = 0; i < data.length; i++) {
                        $('#inventaire_id').append('<option id=' + data[i].inventaire_id + ' value=' + data[i].inventaire_id + '>' + data[i].code_inventaire +' - '+ data[i].libelle+'</option>');
                    }
                    $('#inventaire_id').change();
                }
            })
        }
        $(document).ready(function(){
            inventaire();

        });
    </script>
@endsection
